<?php

define("SKIP_KOHANA", true);
require_once("/opt/monitor/op5/ninja/index.php");

// Name of the dashboard to copy to the users
$dashboard_name = 'Dashboard for fmikker';

// Name of the user that owns (created) the dashboard
$dashboard_user = 'fmikker';

// List of usernames to copy the dashboard to,
// could be fetched from multiple locations
$target_users = array('asjoholm');

$user = new User_AlwaysAuth_Model();
$user->set_username($dashboard_user);

$auth = op5auth::instance();
$auth->force_user($user);

$dashboard = DashboardPool_Model::all()->reduce_by(
    'name', $dashboard_name, '='
)->one();

if (!$dashboard) {
    echo "No dashboard with the name '$dashboard_name' found that was created by user '$dashboard_user'\n";
    exit(1);
}

$raw = $dashboard->export_array();
foreach ($target_users as $username) {
    $raw['dashboard']['username'] = $username;
    $raw['dashboard']['name'] = $dashboard_name . ' (' . $username . ')';
    try {
        $user_dashboard = new Dashboard_Model();
        $user_dashboard->import_array($raw);
        echo "Copied dashboard to user '$username'\n";
    } catch (Exception $e) {
        echo "Failed to copy dashboard to user '$username'\n";
        echo $e->getMessage() . "\n";
    }
}
