/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd.env;

import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.statsd.env.AbstractDimensionResolver;
import com.itrsgroup.collection.instr.statsd.env.EnvironmentVariableResolver;
import java.util.Set;

final class CloudFoundryDimensionResolver
extends AbstractDimensionResolver {
    static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    static final String CF_INSTANCE_GUID = "CF_INSTANCE_GUID";
    static final String CF_INSTANCE_INDEX = "CF_INSTANCE_INDEX";
    static final String CF_INSTANCE_INTERNAL_IP = "CF_INSTANCE_INTERNAL_IP";
    static final String CF_INSTANCE_IP = "CF_INSTANCE_IP";
    private static final String SPACE_NAME = "space_name";
    private static final String APP_NAME = "application_name";

    CloudFoundryDimensionResolver(EnvironmentVariableResolver variableResolver) {
        super(variableResolver);
    }

    @Override
    public Set<Dimension> resolve() {
        Set<Dimension> set = super.resolve();
        this.addDimension(set, CF_INSTANCE_GUID);
        this.addDimension(set, CF_INSTANCE_INDEX);
        this.addDimension(set, CF_INSTANCE_INTERNAL_IP);
        this.addDimension(set, CF_INSTANCE_IP);
        String json = this.getVariableResolver().getenv(VCAP_APPLICATION);
        if (json != null && !json.trim().isEmpty()) {
            CloudFoundryDimensionResolver.addDimension(set, json, APP_NAME);
            CloudFoundryDimensionResolver.addDimension(set, json, SPACE_NAME);
        }
        return set;
    }

    private static void addDimension(Set<Dimension> set, String json, String prop) {
        String val = CloudFoundryDimensionResolver.readJsonProperty(json, prop);
        if (val != null && !val.trim().isEmpty()) {
            set.add(Dimension.of(prop, val));
        }
    }

    private static String readJsonProperty(String json, String prop) {
        char c;
        int i;
        String key = "\"" + prop + "\"";
        int idx = json.indexOf(key);
        if (idx == -1) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = json.length();
        for (i = idx + key.length(); i < len && (Character.isWhitespace(c = json.charAt(i)) || c == ':' || c == '\"'); ++i) {
        }
        while (i < len) {
            c = json.charAt(i);
            if (c == '\"') {
                if (json.charAt(i - 1) != '\\') break;
                builder.setLength(builder.length() - 1);
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }
}

