/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd;

import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.statsd.NoOpStatsdClient;
import com.itrsgroup.collection.instr.statsd.QueuingStatsdSender;
import com.itrsgroup.collection.instr.statsd.StatsdChannel;
import com.itrsgroup.collection.instr.statsd.StatsdClient;
import com.itrsgroup.collection.instr.statsd.StatsdClientImpl;
import com.itrsgroup.collection.instr.statsd.StdoutStatsdChannel;
import com.itrsgroup.collection.instr.statsd.TcpStatsdChannel;
import com.itrsgroup.collection.instr.statsd.UdpStatsdChannel;
import com.itrsgroup.collection.instr.statsd.env.DimensionResolverFactory;
import com.itrsgroup.collection.instr.statsd.env.EnvironmentVariableResolver;
import com.itrsgroup.collection.instr.statsd.env.SystemEnvironmentVariableResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class StatsdClientBuilder {
    private static final int DEFAULT_MAX_MESSAGE_SIZE_TCP = 4096;
    private static final int DEFAULT_MAX_MESSAGE_SIZE_UDP = 1432;
    private static final int DEFAULT_QUEUE_SIZE = 8192;
    private static final int DEFAULT_PORT = 8125;
    private static final long DEFAULT_SAMPLING_INTERVAL = 10000L;
    static final String DISABLE_ENV = "STATSD_DISABLE";
    static final String INTERVAL_ENV = "STATSD_INTERVAL";
    static final String SERVER_ENV = "STATSD_SERVER";
    static final String PORT_ENV = "STATSD_PORT";
    static final String PROTOCOL_ENV = "STATSD_PROTOCOL";
    static final String QUEUE_SIZE_ENV = "STATSD_QUEUE_SIZE";
    static final String MAX_MESSAGE_SIZE_ENV = "STATSD_MAX_MESSAGE_SIZE";
    static final String DISABLE_PLATFORM_DIMENSIONS_ENV = "STATSD_DISABLE_PLATFORM_DIMENSIONS";
    static final String DIMENSION_ENV_PREFIX = "STATSD_DIMENSION_";
    private final EnvironmentVariableResolver variableResolver;
    private final Set<Dimension> defaultDimensions;
    private ChannelType channelType;
    private int queueSize;
    private Integer maxMessageSize;
    private long samplingInterval;
    private Consumer<Throwable> errorCallback;
    private InetAddress server;
    private int port;
    private boolean disablePlatformDimensions;

    public StatsdClientBuilder() {
        this(new SystemEnvironmentVariableResolver());
    }

    StatsdClientBuilder(EnvironmentVariableResolver variableResolver) {
        this.variableResolver = variableResolver;
        this.channelType = ChannelType.UDP;
        this.queueSize = 8192;
        this.samplingInterval = 10000L;
        this.port = 8125;
        this.errorCallback = t -> {};
        this.defaultDimensions = new LinkedHashSet<Dimension>();
    }

    public StatsdClientBuilder channelType(ChannelType type) {
        this.channelType = type;
        return this;
    }

    public StatsdClientBuilder maxMessageSize(int size) {
        if (size < 128) {
            throw new IllegalArgumentException("size must be 128 or greater");
        }
        this.maxMessageSize = size;
        return this;
    }

    public StatsdClientBuilder samplingInterval(long samplingInterval) {
        if (samplingInterval < 1L) {
            throw new IllegalArgumentException("samplingInterval must be greater than zero");
        }
        this.samplingInterval = samplingInterval;
        return this;
    }

    public StatsdClientBuilder queueSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.queueSize = size;
        return this;
    }

    public StatsdClientBuilder errorCallback(Consumer<Throwable> callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        this.errorCallback = callback;
        return this;
    }

    public StatsdClientBuilder server(InetAddress server) {
        Objects.requireNonNull(server, "server must not be null");
        this.server = server;
        return this;
    }

    public StatsdClientBuilder port(int port) {
        StatsdClientBuilder.validatePort(port);
        this.port = port;
        return this;
    }

    private static void validatePort(int port) {
        if (port < 1 || port >= 65536) {
            throw new IllegalArgumentException("port must be greater than zero and less than 65536");
        }
    }

    public StatsdClientBuilder disablePlatformDimensions() {
        this.disablePlatformDimensions = true;
        return this;
    }

    public StatsdClientBuilder defaultDimensions(Dimension ... dimensions) {
        Objects.requireNonNull(dimensions, "dimensions must not be null");
        this.defaultDimensions.clear();
        Collections.addAll(this.defaultDimensions, dimensions);
        return this;
    }

    public StatsdClientBuilder defaultDimension(String key, String value) {
        this.defaultDimensions.add(Dimension.of(key, value));
        return this;
    }

    public StatsdClientBuilder defaultDimension(String key) {
        this.defaultDimensions.add(Dimension.of(key));
        return this;
    }

    public StatsdClientBuilder defaultDimension(Dimension dimension) {
        Objects.requireNonNull(dimension, "dimension must not be null");
        this.defaultDimensions.add(dimension);
        return this;
    }

    public StatsdClient build() {
        StatsdChannel channel;
        int maxSize;
        if (Boolean.valueOf(this.variableResolver.getenv(DISABLE_ENV)).booleanValue()) {
            return new NoOpStatsdClient();
        }
        this.server = this.resolveServer();
        this.port = this.resolvePort();
        switch (this.resolveChannelType()) {
            case UDP: {
                maxSize = this.resolveMaxMessageSize(1432);
                channel = new UdpStatsdChannel(this.server, this.port);
                break;
            }
            case TCP: {
                maxSize = this.resolveMaxMessageSize(4096);
                channel = new TcpStatsdChannel(this.server, this.port);
                break;
            }
            case STDOUT: {
                maxSize = this.resolveMaxMessageSize(4096);
                channel = new StdoutStatsdChannel();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.defaultDimensions.addAll(this.resolveEnvVariableDimensions());
        if (!this.resolveDisablePlatformDimensions()) {
            this.defaultDimensions.addAll(DimensionResolverFactory.create(this.variableResolver).resolve());
        }
        QueuingStatsdSender sender = new QueuingStatsdSender(channel, maxSize, this.resolveQueueSize(), this.errorCallback);
        return new StatsdClientImpl(sender, this.defaultDimensions, this.resolveSamplingInterval(), maxSize, this.errorCallback);
    }

    private InetAddress resolveServer() {
        String env = this.variableResolver.getenv(SERVER_ENV);
        if (env == null || env.trim().isEmpty()) {
            return this.server != null ? this.server : InetAddress.getLoopbackAddress();
        }
        try {
            return InetAddress.getByName(env.trim());
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(String.format("Environment variable %s value '%s' is not a valid address or hostname", SERVER_ENV, env), ex);
        }
    }

    private int resolvePort() {
        String env = this.variableResolver.getenv(PORT_ENV);
        if (env == null || env.trim().isEmpty()) {
            return this.port;
        }
        int p = StatsdClientBuilder.parsePositiveInt(PORT_ENV, env);
        StatsdClientBuilder.validatePort(p);
        return p;
    }

    private ChannelType resolveChannelType() {
        String env = this.variableResolver.getenv(PROTOCOL_ENV);
        if ("TCP".equalsIgnoreCase(env)) {
            return ChannelType.TCP;
        }
        if ("UDP".equalsIgnoreCase(env)) {
            return ChannelType.UDP;
        }
        if ("STDOUT".equalsIgnoreCase(env)) {
            return ChannelType.STDOUT;
        }
        return this.channelType;
    }

    private int resolveMaxMessageSize(int defaultValue) {
        String env = this.variableResolver.getenv(MAX_MESSAGE_SIZE_ENV);
        if (env == null || env.trim().isEmpty()) {
            return this.maxMessageSize == null ? defaultValue : this.maxMessageSize;
        }
        return StatsdClientBuilder.parsePositiveInt(MAX_MESSAGE_SIZE_ENV, env);
    }

    private Set<Dimension> resolveEnvVariableDimensions() {
        HashSet<Dimension> set = new HashSet<Dimension>();
        this.variableResolver.getenv().forEach((k, v) -> {
            if (k.startsWith(DIMENSION_ENV_PREFIX)) {
                set.add(Dimension.of(k.substring(DIMENSION_ENV_PREFIX.length()), v));
            }
        });
        return set;
    }

    private boolean resolveDisablePlatformDimensions() {
        String env = this.variableResolver.getenv(DISABLE_PLATFORM_DIMENSIONS_ENV);
        return env == null || env.trim().isEmpty() ? this.disablePlatformDimensions : Boolean.parseBoolean(env.toLowerCase().trim());
    }

    private long resolveSamplingInterval() {
        String env = this.variableResolver.getenv(INTERVAL_ENV);
        return env == null || env.trim().isEmpty() ? this.samplingInterval : StatsdClientBuilder.parsePositiveLong(INTERVAL_ENV, env);
    }

    private int resolveQueueSize() {
        String env = this.variableResolver.getenv(QUEUE_SIZE_ENV);
        return env == null || env.trim().isEmpty() ? this.queueSize : StatsdClientBuilder.parsePositiveInt(QUEUE_SIZE_ENV, env);
    }

    private static int parsePositiveInt(String var, String val) {
        try {
            int i = Integer.parseInt(val);
            if (i < 1) {
                throw new IllegalArgumentException(String.format("Environment variable %s must be positive", var));
            }
            return i;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Environment variable %s value '%s' is not a valid integer", var, val));
        }
    }

    private static long parsePositiveLong(String var, String val) {
        try {
            long i = Long.parseLong(val);
            if (i < 1L) {
                throw new IllegalArgumentException(String.format("Environment variable %s must be positive", var));
            }
            return i;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Environment variable %s value '%s' is not a valid long integer", var, val));
        }
    }

    public static enum ChannelType {
        UDP,
        TCP,
        STDOUT;

    }
}

