/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.collection.instr.jvm.JvmMetricsCollectorBase;
import com.itrsgroup.collection.instr.jvm.MXBeanSupplier;
import com.itrsgroup.platform.datamodel.Unit;
import java.lang.management.OperatingSystemMXBean;
import java.util.Collections;
import java.util.function.Consumer;

class JvmOsCollector
extends JvmMetricsCollectorBase {
    private final OperatingSystemMXBean operatingSystemMXBean;

    JvmOsCollector(MXBeanSupplier mxBeanSupplier) {
        super(mxBeanSupplier);
        this.operatingSystemMXBean = mxBeanSupplier.getOperatingSystemMXBean();
    }

    @Override
    public void collect(MetricsClient client, Consumer<Throwable> errorCallback) {
        double loadAverage = this.operatingSystemMXBean.getSystemLoadAverage();
        if (loadAverage >= 0.0) {
            client.gauge("jvm_os_system_load_average", loadAverage, Unit.NONE);
        }
        JvmOsCollector.attribute(client, "jvm_os_name", this.operatingSystemMXBean.getName(), Collections.emptySet());
        JvmOsCollector.attribute(client, "jvm_os_version", this.operatingSystemMXBean.getVersion(), Collections.emptySet());
        JvmOsCollector.attribute(client, "jvm_os_available_processors", String.valueOf(this.operatingSystemMXBean.getAvailableProcessors()), Collections.emptySet());
    }
}

