/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.jvm.JvmMetrics;
import com.itrsgroup.collection.instr.jvm.JvmMetricsBuilder;
import com.itrsgroup.collection.instr.statsd.StatsdClientBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.util.concurrent.TimeUnit;

public class JvmMetricsAgent {
    private static final String OPTION_SEP = ",";
    private static final String VALUE_SEP = "=";
    private static final String DIMENSION_SEP = ":";
    private static final String ARG_COLLECT = "collect";
    private static final String ARG_COLLECT_MEMORY = "memory";
    private static final String ARG_COLLECT_OS = "os";
    private static final String ARG_COLLECT_RUNTIME = "runtime";
    private static final String ARG_COLLECT_THREADING = "threading";
    private static final String ARG_DIMENSION = "dimension";
    private static final String ARG_LOG = "log";
    private static final String ARG_MAX_MESSAGE_SIZE = "maxMessageSize";
    private static final String ARG_REPORTING_INTERVAL = "reportingInterval";
    private static final String ARG_PROTOCOL = "protocol";
    private static final String ARG_PROTOCOL_TCP = "tcp";
    private static final String ARG_PROTOCOL_UDP = "udp";
    private static final String ARG_PROTOCOL_STDOUT = "stdout";
    private static final String ARG_WORKER_THREADS = "workerThreads";

    private JvmMetricsAgent() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        try {
            JvmMetricsAgent.start(agentArgs);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(String.format("%s: %s", JvmMetricsAgent.class.getSimpleName(), ex.getMessage()));
            System.exit(1);
        }
        catch (Exception ex) {
            System.err.println(String.format("%s: Startup failed", JvmMetricsAgent.class.getSimpleName()));
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static JvmMetrics start(String agentArgs) {
        JvmMetricsBuilder builder = new JvmMetricsBuilder();
        StatsdClientBuilder clientBuilder = new StatsdClientBuilder();
        if (agentArgs != null && !agentArgs.trim().isEmpty()) {
            block40: for (String pair : agentArgs.trim().split(OPTION_SEP)) {
                String[] split = pair.split(VALUE_SEP);
                if (split.length > 2) {
                    throw new IllegalArgumentException(String.format("Invalid argument '%s'", pair));
                }
                String arg = split[0].trim();
                String val = split.length == 1 ? null : split[1].trim();
                switch (arg) {
                    case "collect": {
                        switch (JvmMetricsAgent.requiredValue(arg, val)) {
                            case "memory": {
                                builder.collectMemoryMetrics();
                                continue block40;
                            }
                            case "os": {
                                builder.collectOperatingSystemMetrics();
                                continue block40;
                            }
                            case "runtime": {
                                builder.collectRuntimeMetrics();
                                continue block40;
                            }
                            case "threading": {
                                builder.collectThreadMetrics();
                                continue block40;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Invalid collect option '%s'", val));
                    }
                    case "dimension": {
                        String[] dim = JvmMetricsAgent.requiredValue(arg, val).split(DIMENSION_SEP);
                        String dimKey = dim[0].trim();
                        String dimValue = dim.length == 1 ? null : dim[1].trim();
                        clientBuilder.defaultDimension(dimKey, dimValue);
                        continue block40;
                    }
                    case "log": {
                        builder.errorCallback(JvmMetricsAgent::logError);
                        clientBuilder.errorCallback(JvmMetricsAgent::logError);
                        continue block40;
                    }
                    case "maxMessageSize": {
                        clientBuilder.maxMessageSize(JvmMetricsAgent.parseInt(arg, val, 128));
                        continue block40;
                    }
                    case "reportingInterval": {
                        builder.reportingInterval(JvmMetricsAgent.parseInt(arg, val, 1000), TimeUnit.MILLISECONDS);
                        continue block40;
                    }
                    case "protocol": {
                        switch (JvmMetricsAgent.requiredValue(arg, val)) {
                            case "tcp": {
                                clientBuilder.channelType(StatsdClientBuilder.ChannelType.TCP);
                                continue block40;
                            }
                            case "udp": {
                                clientBuilder.channelType(StatsdClientBuilder.ChannelType.UDP);
                                continue block40;
                            }
                            case "stdout": {
                                clientBuilder.channelType(StatsdClientBuilder.ChannelType.STDOUT);
                                continue block40;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Invalid protocol option '%s'", val));
                    }
                    case "workerThreads": {
                        builder.workerThreads(JvmMetricsAgent.parseInt(arg, val, 1));
                        continue block40;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Invalid argument '%s'", arg));
                    }
                }
            }
        }
        return builder.client(clientBuilder.build()).build();
    }

    private static int parseInt(String arg, String val, int min) {
        int n;
        JvmMetricsAgent.requiredValue(arg, val);
        try {
            n = Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("%s is invalid: '%s'", arg, val));
        }
        if (n < min) {
            throw new IllegalArgumentException(String.format("%s must be %d or greater", arg, min));
        }
        return n;
    }

    private static String requiredValue(String arg, String val) {
        if (val == null || val.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s argument requires a value", arg));
        }
        return val;
    }

    private static void logError(Throwable t) {
        try (StringWriter writer = new StringWriter();
             PrintWriter pw = new PrintWriter(writer);){
            pw.write(JvmMetricsAgent.class.getSimpleName());
            pw.write(": ");
            t.printStackTrace(pw);
            pw.flush();
            System.err.println(writer.toString());
        }
        catch (IOException ignored) {
            t.printStackTrace();
        }
    }
}

