/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd;

import com.itrsgroup.collection.instr.AbstractMetricsClient;
import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.statsd.StatsdClient;
import com.itrsgroup.collection.instr.statsd.StatsdSender;
import com.itrsgroup.platform.datamodel.Severity;
import com.itrsgroup.platform.datamodel.Unit;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Formatter;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class StatsdClientImpl
extends AbstractMetricsClient
implements StatsdClient {
    private static final int THREAD_POOL_SIZE = 2;
    private static final ThreadLocal<ThreadState> THREAD_STATE = ThreadLocal.withInitial(() -> new ThreadState());
    static final Charset MESSAGE_ENCODING = StandardCharsets.UTF_8;
    private final StatsdSender sender;
    private final Consumer<Throwable> errorCallback;
    private final int maxMessageSize;
    private final Set<Dimension> defaultDimensions;
    private final String defaultDimensionString;
    private Clock clock;

    protected StatsdClientImpl(StatsdSender sender, Set<Dimension> defaultDimensions, long samplingInterval, int maxMessageSize, Consumer<Throwable> errorCallback) {
        this(sender, defaultDimensions, samplingInterval, maxMessageSize, errorCallback, Clock.systemDefaultZone());
    }

    StatsdClientImpl(StatsdSender sender, Set<Dimension> defaultDimensions, long samplingInterval, int maxMessageSize, Consumer<Throwable> errorCallback, Clock clock) {
        super(samplingInterval, errorCallback, 2);
        this.errorCallback = errorCallback;
        this.sender = sender;
        this.maxMessageSize = maxMessageSize;
        this.clock = clock;
        this.defaultDimensions = defaultDimensions;
        this.defaultDimensionString = StatsdClientImpl.buildDefaultDimensions(defaultDimensions);
        this.submitTask(sender);
    }

    private static String buildDefaultDimensions(Set<Dimension> defaults) {
        StringBuilder builder = StatsdClientImpl.builder();
        StatsdClientImpl.appendDimensions(builder, defaults);
        return builder.toString();
    }

    @Override
    protected void doAttribute(String name, String value, Set<Dimension> dimensions) {
        String escaped = value.indexOf(10) == -1 ? value : value.replace("\n", "\\n");
        StringBuilder builder = StatsdClientImpl.builder().append(name).append(':').append(escaped.getBytes(MESSAGE_ENCODING).length).append("|a|").append(escaped);
        this.submit(builder, dimensions);
    }

    @Override
    protected void doCount(String metric, long delta, double sampleRate, Set<Dimension> dimensions) {
        StringBuilder builder = StatsdClientImpl.builder().append(metric).append(":").append(delta).append("|c");
        StatsdClientImpl.appendSampleRate(builder, sampleRate);
        this.submit(builder, dimensions);
    }

    @Override
    protected void doEvent(String name, String message, Severity severity, Set<Dimension> dimensions) {
        String escaped = message.indexOf(10) == -1 ? message : message.replace("\n", "\\n");
        StringBuilder builder = StatsdClientImpl.builder().append(name).append(':').append(escaped.getBytes(MESSAGE_ENCODING).length).append("|e|").append(escaped).append("|t:").append(this.clock.millis()).append("|s:").append(severity.name());
        this.submit(builder, dimensions);
    }

    @Override
    protected void doGauge(String metric, double value, boolean isDelta, Unit unit, Set<Dimension> dimensions) {
        StringBuilder builder = StatsdClientImpl.builder().append(metric).append(":");
        if (isDelta && value >= 0.0) {
            builder.append('+');
        }
        builder.append(value).append("|g");
        if (unit != Unit.NONE) {
            builder.append("|u:").append(unit.description());
        }
        this.submit(builder, dimensions);
    }

    @Override
    protected void doTimer(String name, long value, TimeUnit unit, double sampleRate, Set<Dimension> dimensions) {
        ThreadState state = StatsdClientImpl.state();
        StringBuilder builder = state.builder.append(name).append(":");
        switch (unit) {
            case NANOSECONDS: {
                state.formatter.format("%.6f", StatsdClientImpl.fractionalMillis(value, unit));
                break;
            }
            case MICROSECONDS: {
                state.formatter.format("%.3f", StatsdClientImpl.fractionalMillis(value, unit));
                break;
            }
            default: {
                builder.append((long)StatsdClientImpl.fractionalMillis(value, unit));
            }
        }
        builder.append("|ms");
        StatsdClientImpl.appendSampleRate(builder, sampleRate);
        this.submit(builder, dimensions);
    }

    @Override
    protected void doUnique(String metric, String identifier, Set<Dimension> dimensions) {
        StringBuilder builder = StatsdClientImpl.builder().append(metric).append(':').append(identifier).append("|s");
        this.submit(builder, dimensions);
    }

    private void submit(StringBuilder builder, Set<Dimension> dimensions) {
        if (this.isClosing()) {
            return;
        }
        try {
            StatsdClientImpl.appendDimensions(builder, dimensions);
            builder.append(this.defaultDimensionString).append('\n');
            if (builder.length() > this.maxMessageSize) {
                throw new IllegalArgumentException(String.format("Message length %d exceeds maximum size %d: %s", builder.length(), this.maxMessageSize, builder));
            }
            byte[] encoded = builder.toString().getBytes(MESSAGE_ENCODING);
            this.sender.submit(encoded);
        }
        catch (Throwable t) {
            this.errorCallback.accept(t);
        }
    }

    private static void appendDimensions(StringBuilder builder, Set<Dimension> dimensions) {
        int len = dimensions.size();
        if (len > 0) {
            builder.append("|#");
            for (Dimension d : dimensions) {
                StatsdClientImpl.appendDimension(builder, d);
                builder.append(",");
            }
            builder.setLength(builder.length() - 1);
        }
    }

    private static void appendDimension(StringBuilder builder, Dimension dim) {
        builder.append(dim.getKey());
        String value = dim.getValue();
        if (value != null) {
            builder.append(':').append(value);
        }
    }

    private static void appendSampleRate(StringBuilder builder, double sampleRate) {
        if (sampleRate > 0.0 && sampleRate < 1.0) {
            builder.append("|@").append(sampleRate);
        }
    }

    @Override
    protected void doClose() {
        try {
            this.sender.close();
        }
        catch (IOException ex) {
            this.errorCallback.accept(ex);
        }
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Set<Dimension> getDefaultDimensions() {
        return this.defaultDimensions;
    }

    StatsdSender getSender() {
        return this.sender;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    private static ThreadState state() {
        ThreadState state = THREAD_STATE.get();
        state.builder.setLength(0);
        return state;
    }

    private static StringBuilder builder() {
        return StatsdClientImpl.state().builder;
    }

    private static final class ThreadState {
        private final StringBuilder builder = new StringBuilder();
        private final Formatter formatter = new Formatter(this.builder);

        private ThreadState() {
        }
    }
}

