/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd;

import com.itrsgroup.collection.instr.statsd.CircularQueue;
import com.itrsgroup.collection.instr.statsd.StatsdChannel;
import com.itrsgroup.collection.instr.statsd.StatsdSender;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class QueuingStatsdSender
implements StatsdSender {
    private static final long POLL_INTERVAL = 100L;
    private static final long RECONNECT_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    static final String ERR_MESSAGE_DROPPED = "At least one message was dropped due to a full sending queue. This may indicate a network problem or that a larger sending queue size is necessary to support the load. This exception will not be thrown again.";
    private final StatsdChannel channel;
    private final Consumer<Throwable> errorCallback;
    private final CircularQueue<byte[]> queue;
    private final ByteBuffer buffer;
    private final long reconnectInterval;
    private final int queueSize;
    private final int maxMessageSize;
    private volatile boolean warnedDroppedMsg;
    private volatile boolean connected;
    private volatile boolean closing;
    private long lastConnectAttempt;

    QueuingStatsdSender(StatsdChannel channel, int maxMessageSize, int queueSize, Consumer<Throwable> errorCallback) {
        this(channel, maxMessageSize, queueSize, errorCallback, RECONNECT_INTERVAL);
    }

    QueuingStatsdSender(StatsdChannel channel, int maxMessageSize, int queueSize, Consumer<Throwable> errorCallback, long reconnectInterval) {
        this.channel = channel;
        this.errorCallback = errorCallback;
        this.queueSize = queueSize;
        this.queue = new CircularQueue(queueSize, this::onDroppedMessage);
        this.maxMessageSize = maxMessageSize;
        this.buffer = ByteBuffer.allocate(maxMessageSize);
        this.reconnectInterval = reconnectInterval;
    }

    private void onDroppedMessage() {
        if (!this.warnedDroppedMsg) {
            this.warnedDroppedMsg = true;
            this.errorCallback.accept(new IOException(ERR_MESSAGE_DROPPED));
        }
    }

    @Override
    public void run() {
        while (!this.closing) {
            try {
                this.runOnce();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                this.errorCallback.accept(t);
                return;
            }
        }
    }

    void runOnce() throws InterruptedException {
        if (this.connected || this.connect()) {
            this.sendNextMessage();
        }
    }

    private boolean connect() throws InterruptedException {
        long now = System.currentTimeMillis();
        if (now - this.lastConnectAttempt >= this.reconnectInterval) {
            this.lastConnectAttempt = now;
            try {
                this.channel.connect();
                this.connected = true;
                return true;
            }
            catch (IOException ex) {
                this.errorCallback.accept(ex);
                this.tryCloseChannel();
            }
        }
        Thread.sleep(100L);
        this.connected = false;
        return false;
    }

    private void sendNextMessage() throws InterruptedException {
        try {
            byte[] msg = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (this.closing || msg == null) {
                return;
            }
            this.buffer.put(msg);
            this.buffer.flip();
            int written = this.channel.send(this.buffer);
            if (written != -1 && written != msg.length) {
                throw new IOException(String.format("Message was not completely delivered - %d bytes of %d were written", written, msg.length));
            }
        }
        catch (IOException ex) {
            this.errorCallback.accept(ex);
            this.tryCloseChannel();
        }
        finally {
            this.buffer.clear();
        }
    }

    private void tryCloseChannel() {
        try {
            this.closeChannel();
        }
        catch (IOException ex) {
            this.errorCallback.accept(ex);
        }
    }

    private void closeChannel() throws IOException {
        this.connected = false;
        this.channel.close();
    }

    @Override
    public void submit(byte[] msg) {
        if (this.closing) {
            return;
        }
        this.queue.add(msg);
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        this.closeChannel();
    }

    Consumer<Throwable> getErrorCallback() {
        return this.errorCallback;
    }

    StatsdChannel getChannel() {
        return this.channel;
    }

    boolean isConnected() {
        return this.connected;
    }

    int getQueueSize() {
        return this.queueSize;
    }

    int getMaxMessageSize() {
        return this.maxMessageSize;
    }
}

