/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.collection.instr.jvm.JvmMetricsCollectorBase;
import com.itrsgroup.collection.instr.jvm.MXBeanSupplier;
import com.itrsgroup.platform.datamodel.Unit;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

class JvmMemoryCollector
extends JvmMetricsCollectorBase {
    private final Map<String, Set<Dimension>> poolDimensions = new ConcurrentHashMap<String, Set<Dimension>>();
    private final Map<String, Set<Dimension>> gcDimensions = new ConcurrentHashMap<String, Set<Dimension>>();

    JvmMemoryCollector(MXBeanSupplier mxBeanSupplier) {
        super(mxBeanSupplier);
    }

    @Override
    public void collect(MetricsClient client, Consumer<Throwable> errorCallback) {
        MemoryMXBean memoryMXBean = this.mxBeanSupplier().getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
        client.gauge("jvm_memory_heap_used", (double)heapMemoryUsage.getUsed(), Unit.BYTES);
        client.gauge("jvm_memory_heap_committed", (double)heapMemoryUsage.getCommitted(), Unit.BYTES);
        long heapMemoryUsageMax = heapMemoryUsage.getMax();
        if (heapMemoryUsageMax != -1L) {
            client.gauge("jvm_memory_heap_max", (double)heapMemoryUsageMax, Unit.BYTES);
        }
        client.gauge("jvm_memory_non_heap_used", (double)nonHeapMemoryUsage.getUsed(), Unit.BYTES);
        client.gauge("jvm_memory_non_heap_committed", (double)nonHeapMemoryUsage.getCommitted(), Unit.BYTES);
        long nonHeapMemoryUsageMax = nonHeapMemoryUsage.getMax();
        if (nonHeapMemoryUsageMax != -1L) {
            client.gauge("jvm_memory_non_heap_max", (double)nonHeapMemoryUsageMax, Unit.BYTES);
        }
        for (MemoryPoolMXBean pool : this.mxBeanSupplier().getMemoryPoolMXBeans()) {
            long max;
            MemoryUsage usage = pool.getUsage();
            if (usage == null) continue;
            if (pool.getType() == MemoryType.HEAP) {
                this.emitMemoryPoolMetric(client, "jvm_memory_pool_heap_used", usage.getUsed(), pool.getName());
                this.emitMemoryPoolMetric(client, "jvm_memory_pool_heap_committed", usage.getCommitted(), pool.getName());
                max = usage.getMax();
                if (max == -1L) continue;
                this.emitMemoryPoolMetric(client, "jvm_memory_pool_heap_max", max, pool.getName());
                continue;
            }
            if (pool.getType() != MemoryType.NON_HEAP) continue;
            this.emitMemoryPoolMetric(client, "jvm_memory_pool_non_heap_used", usage.getUsed(), pool.getName());
            this.emitMemoryPoolMetric(client, "jvm_memory_pool_non_heap_committed", usage.getCommitted(), pool.getName());
            max = usage.getMax();
            if (max == -1L) continue;
            this.emitMemoryPoolMetric(client, "jvm_memory_pool_non_heap_max", max, pool.getName());
        }
        for (GarbageCollectorMXBean gc : this.mxBeanSupplier().getGarbageCollectorMXBeans()) {
            Set<Dimension> dimensions = this.gcDimensions(gc.getName());
            client.gauge("jvm_memory_gc_collection_count", gc.getCollectionCount(), Unit.NONE, dimensions);
            client.gauge("jvm_memory_gc_collection_time", gc.getCollectionTime(), Unit.MILLISECONDS, dimensions);
        }
    }

    private void emitMemoryPoolMetric(MetricsClient client, String metricName, long value, String poolName) {
        client.gauge(metricName, value, Unit.BYTES, this.poolDimensions(poolName));
    }

    private Set<Dimension> poolDimensions(String name) {
        return this.cachedDimension(this.poolDimensions, name, "jvm_memory_pool_name");
    }

    private Set<Dimension> gcDimensions(String name) {
        return this.cachedDimension(this.gcDimensions, name, "jvm_memory_gc_name");
    }

    private Set<Dimension> cachedDimension(Map<String, Set<Dimension>> map, String key, String dimensionName) {
        Set cached = map.get(key);
        return cached == null ? map.computeIfAbsent(key, k -> Collections.singleton(Dimension.of(dimensionName, key))) : cached;
    }
}

