/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd.env;

import com.itrsgroup.collection.instr.statsd.env.CloudFoundryDimensionResolver;
import com.itrsgroup.collection.instr.statsd.env.DefaultDimensionResolver;
import com.itrsgroup.collection.instr.statsd.env.DimensionResolver;
import com.itrsgroup.collection.instr.statsd.env.EnvironmentVariableResolver;
import com.itrsgroup.collection.instr.statsd.env.KubernetesDimensionResolver;
import com.itrsgroup.collection.instr.statsd.env.SystemEnvironmentVariableResolver;

public final class DimensionResolverFactory {
    private DimensionResolverFactory() {
    }

    public static DimensionResolver create() {
        return DimensionResolverFactory.create(new SystemEnvironmentVariableResolver());
    }

    public static DimensionResolver create(EnvironmentVariableResolver variableResolver) {
        if (DimensionResolverFactory.isCloudFoundry(variableResolver)) {
            return new CloudFoundryDimensionResolver(variableResolver);
        }
        if (DimensionResolverFactory.isKubernetes(variableResolver)) {
            return new KubernetesDimensionResolver(variableResolver);
        }
        return new DefaultDimensionResolver(variableResolver);
    }

    private static boolean isCloudFoundry(EnvironmentVariableResolver variableResolver) {
        return variableResolver.getenv("VCAP_APPLICATION") != null;
    }

    private static boolean isKubernetes(EnvironmentVariableResolver variableResolver) {
        return variableResolver.getenv("POD_NAME") != null;
    }
}

