/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd.env;

import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.statsd.env.DimensionResolver;
import com.itrsgroup.collection.instr.statsd.env.EnvironmentVariableResolver;
import java.util.HashSet;
import java.util.Set;

abstract class AbstractDimensionResolver
implements DimensionResolver {
    static final String HOSTNAME_VAR = "HOSTNAME";
    private final EnvironmentVariableResolver variableResolver;

    protected AbstractDimensionResolver(EnvironmentVariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    @Override
    public Set<Dimension> resolve() {
        HashSet<Dimension> set = new HashSet<Dimension>();
        this.addDimension(set, HOSTNAME_VAR);
        return set;
    }

    protected EnvironmentVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    protected static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    protected void addDimension(Set<Dimension> set, String env) {
        String val = this.variableResolver.getenv(env);
        if (!AbstractDimensionResolver.isBlank(val)) {
            set.add(Dimension.of(env.toLowerCase(), val));
        }
    }
}

