/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd;

import com.itrsgroup.collection.instr.statsd.StatsdChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;

final class UdpStatsdChannel
implements StatsdChannel {
    private final ChannelSupplier supplier;
    private final InetSocketAddress dest;
    private volatile DatagramChannel channel;

    UdpStatsdChannel(InetAddress host, int port) {
        this(host, port, DatagramChannel::open);
    }

    UdpStatsdChannel(InetAddress host, int port, ChannelSupplier supplier) {
        this.supplier = supplier;
        this.dest = new InetSocketAddress(host, port);
    }

    @Override
    public void connect() throws IOException {
        this.channel = this.supplier.get();
    }

    @Override
    public int send(ByteBuffer buffer) throws IOException {
        DatagramChannel ch = this.channel;
        try {
            return ch == null ? -1 : ch.send(buffer, this.dest);
        }
        catch (AsynchronousCloseException ex) {
            return -1;
        }
    }

    @Override
    public void close() throws IOException {
        DatagramChannel ch = this.channel;
        if (ch != null) {
            ch.close();
        }
    }

    InetSocketAddress getDestination() {
        return this.dest;
    }

    @FunctionalInterface
    static interface ChannelSupplier {
        public DatagramChannel get() throws IOException;
    }
}

