/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class CircularQueue<T> {
    private final T[] elements;
    private final int capacity;
    private final Runnable onDroppedElement;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private int start;
    private int end;
    private boolean full;

    CircularQueue(int capacity, Runnable onDroppedElement) {
        this.capacity = capacity;
        this.onDroppedElement = onDroppedElement;
        this.elements = new Object[capacity];
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
    }

    void add(T element) {
        boolean dropped = false;
        this.lock.lock();
        try {
            if (this.full) {
                this.incrementStart();
                dropped = true;
            }
            this.elements[this.end] = element;
            this.incrementEnd();
            if (this.end == this.start) {
                this.full = true;
            }
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
        if (dropped) {
            this.onDroppedElement.run();
        }
    }

    private void incrementStart() {
        ++this.start;
        if (this.start == this.capacity) {
            this.start = 0;
        }
    }

    private void incrementEnd() {
        ++this.end;
        if (this.end == this.capacity) {
            this.end = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (this.internalSize() == 0) {
                if (nanos <= 0L) {
                    T t = null;
                    return t;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            T elem = this.elements[this.start];
            this.elements[this.start] = null;
            this.incrementStart();
            this.full = false;
            T t = elem;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int internalSize() {
        if (this.start == this.end) {
            return this.full ? this.capacity : 0;
        }
        if (this.end < this.start) {
            return this.capacity - this.start + this.end;
        }
        return this.end - this.start;
    }

    int size() {
        this.lock.lock();
        try {
            int n = this.internalSize();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

