/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.collection.instr.jvm.JvmMemoryCollector;
import com.itrsgroup.collection.instr.jvm.JvmMetrics;
import com.itrsgroup.collection.instr.jvm.JvmMetricsCollector;
import com.itrsgroup.collection.instr.jvm.JvmOsCollector;
import com.itrsgroup.collection.instr.jvm.JvmRuntimeCollector;
import com.itrsgroup.collection.instr.jvm.JvmThreadCollector;
import com.itrsgroup.collection.instr.jvm.MXBeanSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class JvmMetricsBuilder {
    private static final long DEFAULT_REPORTING_INTERVAL = 10000L;
    private static final int DEFAULT_WORKER_THREADS = 2;
    private final Map<Class<?>, JvmMetricsCollector> collectors = new HashMap();
    private final MXBeanSupplier mxBeanSupplier = new MXBeanSupplier();
    private MetricsClient client;
    private Consumer<Throwable> errorCallback = t -> {};
    private long reportingIntervalMillis = 10000L;
    private int workerThreads = 2;

    public JvmMetricsBuilder client(MetricsClient client) {
        Objects.requireNonNull(client, "client must not be null");
        this.client = client;
        return this;
    }

    public JvmMetricsBuilder collectMemoryMetrics() {
        this.addCollector(new JvmMemoryCollector(this.mxBeanSupplier));
        return this;
    }

    public JvmMetricsBuilder collectThreadMetrics() {
        this.addCollector(new JvmThreadCollector(this.mxBeanSupplier));
        return this;
    }

    public JvmMetricsBuilder collectRuntimeMetrics() {
        this.addCollector(new JvmRuntimeCollector(this.mxBeanSupplier));
        return this;
    }

    public JvmMetricsBuilder collectOperatingSystemMetrics() {
        this.addCollector(new JvmOsCollector(this.mxBeanSupplier));
        return this;
    }

    public JvmMetricsBuilder addCollector(JvmMetricsCollector collector) {
        this.collectors.putIfAbsent(collector.getClass(), collector);
        return this;
    }

    public JvmMetricsBuilder reportingInterval(long reportingInterval, TimeUnit unit) {
        long millis = TimeUnit.MILLISECONDS.convert(reportingInterval, unit);
        if (millis < 1000L) {
            throw new IllegalArgumentException("reportingInterval must be 1 second or greater");
        }
        this.reportingIntervalMillis = millis;
        return this;
    }

    public JvmMetricsBuilder workerThreads(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count must be greater than zero");
        }
        this.workerThreads = count;
        return this;
    }

    public JvmMetricsBuilder errorCallback(Consumer<Throwable> callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        this.errorCallback = callback;
        return this;
    }

    public JvmMetrics build() {
        if (this.client == null) {
            throw new IllegalArgumentException("client has not been configured");
        }
        if (this.collectors.size() == 0) {
            this.collectMemoryMetrics();
            this.collectOperatingSystemMetrics();
            this.collectRuntimeMetrics();
            this.collectThreadMetrics();
        }
        return new JvmMetrics(this.client, this.errorCallback, this.reportingIntervalMillis, this.workerThreads, this.collectors.values().toArray(new JvmMetricsCollector[0]));
    }
}

