/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.collection.instr.jvm.JvmMetricsCollector;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class JvmMetrics
implements AutoCloseable {
    private static final AtomicBoolean INSTANTIATED = new AtomicBoolean();
    private final MetricsClient client;
    private final long reportingIntervalMillis;
    private final Consumer<Throwable> errorCallback;
    private final ScheduledExecutorService executor;
    private final JvmMetricsCollector[] collectors;

    JvmMetrics(MetricsClient client, Consumer<Throwable> errorCallback, long reportingIntervalMillis, int workerThreads, JvmMetricsCollector ... collectors) {
        this(client, errorCallback, reportingIntervalMillis, Executors.newScheduledThreadPool(workerThreads, new WorkerThreadFactory()), collectors);
    }

    JvmMetrics(MetricsClient client, Consumer<Throwable> errorCallback, long reportingIntervalMillis, ScheduledExecutorService executor, JvmMetricsCollector ... collectors) {
        if (!INSTANTIATED.compareAndSet(false, true)) {
            throw new IllegalStateException(String.format("An instance of %s already exists. There can only be one instance in the JVM.", this.getClass().getSimpleName()));
        }
        this.client = client;
        this.reportingIntervalMillis = reportingIntervalMillis;
        this.errorCallback = errorCallback;
        this.executor = executor;
        this.collectors = collectors;
        this.start();
    }

    private void start() {
        try {
            for (JvmMetricsCollector collector : this.collectors) {
                Runnable r = () -> {
                    try {
                        collector.collect(this.client, this.errorCallback);
                    }
                    catch (Throwable t) {
                        this.errorCallback.accept(t);
                    }
                };
                this.executor.scheduleWithFixedDelay(r, this.reportingIntervalMillis, this.reportingIntervalMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            this.errorCallback.accept(t);
        }
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    Set<Class<? extends JvmMetricsCollector>> getCollectors() {
        return Arrays.stream(this.collectors).map(Object::getClass).collect(Collectors.toSet());
    }

    MetricsClient getClient() {
        return this.client;
    }

    long getReportingIntervalMillis() {
        return this.reportingIntervalMillis;
    }

    public static void clearInstance() {
        INSTANTIATED.set(false);
    }

    private static final class WorkerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger COUNTER = new AtomicInteger();

        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.format("%s-%d", JvmMetrics.class.getSimpleName(), COUNTER.getAndIncrement()));
            t.setDaemon(true);
            return t;
        }
    }
}

