/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr;

import com.itrsgroup.collection.instr.Dimension;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DimensionalMetricMap<T> {
    private final Map<String, Map<Set<Dimension>, T>> data = new ConcurrentHashMap<String, Map<Set<Dimension>, T>>();

    private Map<Set<Dimension>, T> getOrCreate(String metric) {
        Map map = this.data.get(metric);
        if (map == null) {
            map = this.data.computeIfAbsent(metric, k -> new ConcurrentHashMap());
        }
        return map;
    }

    public T get(String metric, Set<Dimension> dimensions) {
        Map<Set<Dimension>, T> map = this.data.get(metric);
        return map == null ? null : (T)map.get(dimensions);
    }

    public T put(String metric, Set<Dimension> dimensions, T value) {
        return this.getOrCreate(metric).put(dimensions, value);
    }

    public T putIfAbsent(String metric, Set<Dimension> dimensions, T value) {
        Map<Set<Dimension>, T> map = this.getOrCreate(metric);
        return map.putIfAbsent(dimensions, value);
    }

    public T computeIfAbsent(String metric, Set<Dimension> dimensions, Function<Set<Dimension>, T> mappingFunction) {
        return this.getOrCreate(metric).computeIfAbsent(dimensions, mappingFunction);
    }

    public void forEach(Consumer<T> consumer) {
        for (Map.Entry<String, Map<Set<Dimension>, T>> outer : this.data.entrySet()) {
            String metric = outer.getKey();
            for (Map.Entry<Set<Dimension>, T> inner : outer.getValue().entrySet()) {
                if (consumer.accept(metric, inner.getKey(), inner.getValue())) continue;
                return;
            }
        }
    }

    public T remove(String metric, Set<Dimension> dimensions) {
        Map<Set<Dimension>, T> map = this.data.get(metric);
        if (map != null) {
            return map.remove(dimensions);
        }
        return null;
    }

    public void clear() {
        this.data.clear();
    }

    public static interface Consumer<T> {
        public boolean accept(String var1, Set<Dimension> var2, T var3);
    }
}

