/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.platform.datamodel;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Severity {
    NONE(100),
    CRITICAL(70),
    ERROR(60),
    WARN(50),
    INFO(40),
    DEBUG(30),
    TRACE(20);

    private static final Map<Byte, Severity> types;
    private final byte id;

    private Severity(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static Severity of(byte id) {
        Severity type = types.get(id);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException(String.format("Unknown severity: %d", id));
    }

    static {
        types = new HashMap<Byte, Severity>();
        EnumSet.allOf(Severity.class).forEach(s -> types.put(s.id(), (Severity)((Object)s)));
    }
}

