/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.statsd;

import com.itrsgroup.collection.instr.statsd.StatsdChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

final class TcpStatsdChannel
implements StatsdChannel {
    private static final long SOCKET_TIMEOUT = 10000L;
    private final InetSocketAddress address;
    private final IOSupplier<SocketChannel> socketSupplier;
    private final IOSupplier<Selector> selectorSupplier;
    private final long socketTimeout;
    private SocketChannel channel;
    private Selector selector;

    TcpStatsdChannel(InetAddress host, int port) {
        this(host, port, 10000L, SocketChannel::open, () -> SelectorProvider.provider().openSelector());
    }

    TcpStatsdChannel(InetAddress host, int port, long socketTimeout, IOSupplier<SocketChannel> socketSupplier, IOSupplier<Selector> selectorSupplier) {
        this.address = new InetSocketAddress(host, port);
        this.socketTimeout = socketTimeout;
        this.socketSupplier = socketSupplier;
        this.selectorSupplier = selectorSupplier;
    }

    @Override
    public void connect() throws IOException {
        this.channel = this.socketSupplier.get();
        this.channel.configureBlocking(false);
        if (this.channel.connect(this.address)) {
            return;
        }
        this.selector = this.selectorSupplier.get();
        this.channel.register(this.selector, 8);
        if (this.selector.select(this.socketTimeout) == 0) {
            throw new SocketTimeoutException("Timed out on socket channel connection");
        }
        if (!this.channel.finishConnect()) {
            throw new IOException("Failed to finish socket channel connection");
        }
    }

    @Override
    public int send(ByteBuffer buffer) throws IOException {
        int written = this.channel.write(buffer);
        if (buffer.remaining() == 0) {
            return written;
        }
        long retryStartTime = System.currentTimeMillis();
        long retries = 0L;
        do {
            if (System.currentTimeMillis() - retryStartTime >= this.socketTimeout) {
                throw new SocketTimeoutException("Timed out writing to server");
            }
            TcpStatsdChannel.sleep(++retries);
            written += this.channel.write(buffer);
        } while (buffer.remaining() > 0);
        return written;
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeChannel();
        }
        catch (IOException ex) {
            try {
                this.closeSelector();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        this.closeSelector();
    }

    private void closeChannel() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            finally {
                this.channel = null;
            }
        }
    }

    private void closeSelector() throws IOException {
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            finally {
                this.selector = null;
            }
        }
    }

    private static void sleep(long millis) throws IOException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @FunctionalInterface
    static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

