/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.collection.instr.jvm.JvmMetricsCollectorBase;
import com.itrsgroup.collection.instr.jvm.MXBeanSupplier;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class JvmThreadCollector
extends JvmMetricsCollectorBase {
    private static final Thread.State[] THREAD_STATES = Thread.State.values();
    private final ThreadMXBean bean;
    private final int[] stateCounts;
    private final List<Set<Dimension>> stateDimensions;

    JvmThreadCollector(MXBeanSupplier mxBeanSupplier) {
        super(mxBeanSupplier);
        this.bean = mxBeanSupplier.getThreadMXBean();
        this.stateCounts = new int[THREAD_STATES.length];
        this.stateDimensions = new ArrayList<Set<Dimension>>(THREAD_STATES.length);
        for (Thread.State s : THREAD_STATES) {
            this.stateDimensions.add(Collections.singleton(Dimension.of("thread_state", s.toString())));
        }
    }

    @Override
    public void collect(MetricsClient client, Consumer<Throwable> errorCallback) {
        long[] threads2;
        Arrays.fill(this.stateCounts, 0);
        try {
            long[] allThreads = this.bean.getAllThreadIds();
            ThreadInfo[] infos = this.bean.getThreadInfo(allThreads);
            for (int i = 0; i < allThreads.length; ++i) {
                Thread.State state;
                ThreadInfo info = infos[i];
                if (info == null || (state = info.getThreadState()) == null) continue;
                int n = state.ordinal();
                this.stateCounts[n] = this.stateCounts[n] + 1;
            }
            for (Thread.State state : THREAD_STATES) {
                client.gauge("jvm_thread_states", (double)this.stateCounts[state.ordinal()], this.stateDimensions.get(state.ordinal()));
            }
        }
        catch (IllegalArgumentException | SecurityException ex) {
            errorCallback.accept(ex);
        }
        client.gauge("jvm_threads", this.bean.getThreadCount());
        client.gauge("jvm_threads_daemon", this.bean.getDaemonThreadCount());
        client.gauge("jvm_threads_peak", this.bean.getPeakThreadCount());
        client.gauge("jvm_threads_started", this.bean.getTotalStartedThreadCount());
        try {
            threads2 = this.bean.findMonitorDeadlockedThreads();
            client.gauge("jvm_threads_monitor_deadlock", threads2 == null ? 0.0 : (double)threads2.length);
        }
        catch (UnsupportedOperationException threads2) {
        }
        catch (SecurityException ex) {
            errorCallback.accept(ex);
        }
        try {
            threads2 = this.bean.findDeadlockedThreads();
            client.gauge("jvm_threads_deadlock", threads2 == null ? 0.0 : (double)threads2.length);
        }
        catch (UnsupportedOperationException threads3) {
        }
        catch (SecurityException ex) {
            errorCallback.accept(ex);
        }
    }
}

