/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.platform.datamodel;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum Unit {
    NONE(0, null, "none", null, 1.0),
    BYTES(1, null, "bytes", "B", 1.0),
    KILOBYTES(2, BYTES, "kilobytes", "kB", 1000.0),
    KIBIBYTES(3, BYTES, "kibibytes", "KiB", 1024.0),
    MEGABITS(4, BYTES, "megabits", "Mbit", 125000.0),
    MEGABYTES(5, BYTES, "megabytes", "MB", 1000000.0),
    MEBIBYTES(6, BYTES, "mebibytes", "MiB", 1048576.0),
    GIGABYTES(7, BYTES, "gigabytes", "GB", 1.0E9),
    GIBIBYTES(8, BYTES, "gibibytes", "GiB", 1.073741824E9),
    TERABYTES(9, BYTES, "terabytes", "TB", 1.0E12),
    TEBIBYTES(10, BYTES, "tebibytes", "TiB", 1.099511627776E12),
    PETABYTES(11, BYTES, "petabytes", "PB", 1.0E15),
    PEBIBYTES(12, BYTES, "pebibytes", "PiB", 1.125899906842624E15),
    EXABYTES(13, BYTES, "exabytes", "EB", 1.0E18),
    EXBIBYTES(14, BYTES, "exbibytes", "EiB", 1.152921504606847E18),
    BITS_PER_SECOND(30, null, "bits per second", "bit/s", 1.0),
    BYTES_PER_SECOND(31, BITS_PER_SECOND, "bytes per second", "B/s", 8.0),
    KIBIBYTES_PER_SECOND(32, BITS_PER_SECOND, "kibibytes per second", "Kibit/s", 8192.0),
    MEGABITS_PER_SECOND(33, BITS_PER_SECOND, "megabits per second", "Mbit/s", 1000000.0),
    GIGABITS_PER_SECOND(34, BITS_PER_SECOND, "gigabits per second", "Gbit/s", 1.0E9),
    PER_SECOND(50, null, "per second", "/s", 1.0),
    SECONDS(63, null, "seconds", "s", 1.0),
    NANOSECONDS(60, SECONDS, "nanoseconds", "ns", 1.0E-9),
    MICROSECONDS(61, SECONDS, "microseconds", "\u00b5s", 1.0E-6),
    MILLISECONDS(62, SECONDS, "milliseconds", "ms", 0.001),
    MINUTES(64, SECONDS, "minutes", "min", 60.0),
    HOURS(65, SECONDS, "hours", "h", 3600.0),
    DAYS(66, SECONDS, "days", "d", 86400.0),
    DEGREES_CELSIUS(80, null, "degrees Celsius", "\u00b0C", 1.0),
    HERTZ(90, null, "hertz", "Hz", 1.0),
    MEGAHERTZ(91, HERTZ, "megahertz", "MHz", 1000000.0),
    GIGAHERTZ(92, HERTZ, "gigahertz", "GHz", 1.0E9),
    FRACTION(101, null, "fraction", null, 1.0),
    PERCENT(100, FRACTION, "percent", "%", 0.01),
    CORES(110, null, "cores", null, 1.0),
    MILLICORES(111, CORES, "millicores", null, 0.001),
    MICROCORES(112, CORES, "microcores", null, 1.0E-6),
    NANOCORES(113, CORES, "nanocores", null, 1.0E-9),
    EPOCH_NANOSECONDS(120, null, "epoch nanoseconds", "ns", 1.0),
    EPOCH_MILLISECONDS(121, EPOCH_NANOSECONDS, "epoch milliseconds", "ms", 1000000.0),
    METRES(130, null, "metres", "m", 1.0),
    KILOMETRES(131, METRES, "kilometres", "km", 1000.0),
    VOLTS(140, null, "volts", "V", 1.0),
    KILOVOLTS(141, VOLTS, "kilovolts", "kV", 1000.0),
    AMPERES(150, null, "amperes", "A", 1.0),
    MILLIAMPERES(151, AMPERES, "milliamperes", "mA", 0.001),
    JOULES(160, null, "joules", "J", 1.0),
    KILOJOULES(161, JOULES, "kilojoules", "kJ", 1000.0),
    KILOGRAMS(170, null, "kilograms", "kg", 1.0),
    GRAMS(171, KILOGRAMS, "grams", "g", 0.001);

    private static final Map<Short, Unit> unitById;
    private static final Map<String, Unit> unitByDescription;
    private final short id;
    private final Unit base;
    private final String description;
    private final String symbol;
    private final double factor;

    private Unit(short id, Unit base, String description, String symbol, double factor) {
        this.id = id;
        this.base = base;
        this.description = description;
        this.symbol = symbol;
        this.factor = factor;
    }

    public short id() {
        return this.id;
    }

    public boolean isBase() {
        return this.base == null;
    }

    public Unit base() {
        return this.isBase() ? this : this.base;
    }

    public String description() {
        return this.description;
    }

    public String symbol() {
        return this.symbol;
    }

    public double factor() {
        return this.factor;
    }

    public double scale(double value, Unit target) {
        Objects.requireNonNull(target, "target");
        if (this.base() != target.base()) {
            throw new IllegalArgumentException(String.format("target unit %s does not have base %s", new Object[]{target, this.base()}));
        }
        return value * this.factor() / target.factor();
    }

    public static Unit withId(short id) {
        Unit unit = unitById.get(id);
        if (unit != null) {
            return unit;
        }
        throw new IllegalArgumentException(String.format("Invalid ID '%d'", id));
    }

    public static Unit withDescription(String description) {
        Unit unit = unitByDescription.get(description);
        if (unit != null) {
            return unit;
        }
        throw new IllegalArgumentException(String.format("Invalid description '%s'", description));
    }

    static {
        unitById = new HashMap<Short, Unit>();
        unitByDescription = new HashMap<String, Unit>();
        EnumSet.allOf(Unit.class).forEach(u -> {
            unitById.put(u.id(), (Unit)((Object)u));
            unitByDescription.put(u.description(), (Unit)((Object)u));
        });
    }
}

