/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr.jvm;

import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.collection.instr.jvm.JvmMetricsCollectorBase;
import com.itrsgroup.collection.instr.jvm.MXBeanSupplier;
import com.itrsgroup.platform.datamodel.Unit;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.function.Consumer;

class JvmRuntimeCollector
extends JvmMetricsCollectorBase {
    private final RuntimeMXBean runtimeMXBean;

    JvmRuntimeCollector(MXBeanSupplier mxBeanSupplier) {
        super(mxBeanSupplier);
        this.runtimeMXBean = mxBeanSupplier.getRuntimeMXBean();
    }

    @Override
    public void collect(MetricsClient client, Consumer<Throwable> errorCallback) {
        client.gauge("jvm_runtime_start_time", (double)this.runtimeMXBean.getStartTime(), Unit.MILLISECONDS);
        client.gauge("jvm_runtime_uptime", (double)this.runtimeMXBean.getUptime(), Unit.MILLISECONDS);
        JvmRuntimeCollector.attribute(client, "jvm_runtime_name", this.runtimeMXBean.getName(), Collections.emptySet());
        JvmRuntimeCollector.attribute(client, "jvm_runtime_vm_name", this.runtimeMXBean.getVmName(), Collections.emptySet());
        JvmRuntimeCollector.attribute(client, "jvm_runtime_vm_vendor", this.runtimeMXBean.getVmVendor(), Collections.emptySet());
        JvmRuntimeCollector.attribute(client, "jvm_runtime_vm_version", this.runtimeMXBean.getVmVersion(), Collections.emptySet());
        JvmRuntimeCollector.attribute(client, "jvm_runtime_spec_name", this.runtimeMXBean.getSpecName(), Collections.emptySet());
        JvmRuntimeCollector.attribute(client, "jvm_runtime_spec_vendor", this.runtimeMXBean.getSpecVendor(), Collections.emptySet());
        JvmRuntimeCollector.attribute(client, "jvm_runtime_spec_version", this.runtimeMXBean.getSpecVersion(), Collections.emptySet());
    }
}

