/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr;

import java.util.Objects;

public class Dimension {
    private final String key;
    private final String value;
    private final int hash;

    public static Dimension of(String key, String value) {
        return new Dimension(key, value);
    }

    public static Dimension of(String key) {
        return new Dimension(key);
    }

    public Dimension(String key) {
        this(key, null);
    }

    public Dimension(String key, String value) {
        if (key == null || key.trim().isEmpty()) {
            throw new IllegalArgumentException("key must not be null or empty");
        }
        this.key = key;
        this.value = value;
        this.hash = Objects.hash(key, value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dimension)) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        return Objects.equals(this.key, dimension.key) && Objects.equals(this.value, dimension.value);
    }

    public String toString() {
        return String.format("Dimension{%s=%s}", this.key, this.value == null ? "" : this.value);
    }
}

