/*
 * Decompiled with CFR 0.152.
 */
package com.itrsgroup.collection.instr;

import com.itrsgroup.collection.instr.Dimension;
import com.itrsgroup.collection.instr.DimensionalMetricMap;
import com.itrsgroup.collection.instr.InstrumentationUtils;
import com.itrsgroup.collection.instr.MetricsClient;
import com.itrsgroup.platform.datamodel.Severity;
import com.itrsgroup.platform.datamodel.Unit;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;

public abstract class AbstractMetricsClient
implements MetricsClient {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    protected static final Set<Dimension> NO_DIMENSIONS = Collections.emptySet();
    private final DimensionalMetricMap<GaugeSampler> gaugeSamplers;
    private final Consumer<Throwable> errorCallback;
    private final long samplingInterval;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean sampling;
    private final AtomicBoolean closing;

    protected AbstractMetricsClient(long samplingInterval, Consumer<Throwable> errorCallback) {
        this(samplingInterval, errorCallback, 1);
    }

    protected AbstractMetricsClient(long samplingInterval, Consumer<Throwable> errorCallback, int threadPoolSize) {
        this(samplingInterval, errorCallback, threadPoolSize, null);
    }

    AbstractMetricsClient(long samplingInterval, Consumer<Throwable> errorCallback, int threadPoolSize, ScheduledExecutorService executor) {
        Objects.requireNonNull(errorCallback, "errorCallback");
        if (samplingInterval < 1L) {
            throw new IllegalArgumentException("samplingInterval must be greater than zero");
        }
        if (threadPoolSize < 1) {
            throw new IllegalArgumentException("threadPoolSize must be greater than zero");
        }
        this.gaugeSamplers = new DimensionalMetricMap();
        this.errorCallback = errorCallback;
        this.samplingInterval = samplingInterval;
        this.sampling = new AtomicBoolean();
        this.closing = new AtomicBoolean();
        this.executor = executor == null ? this.makeExecutor(threadPoolSize) : executor;
    }

    private ScheduledExecutorService makeExecutor(int size) {
        return Executors.newScheduledThreadPool(size, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(String.format("%s-%d", this.getClass().getSimpleName(), THREAD_COUNTER.getAndIncrement()));
            return t;
        });
    }

    private static boolean shouldSample(double sampleRate) {
        return sampleRate >= 1.0 || sampleRate > ThreadLocalRandom.current().nextDouble();
    }

    @Override
    public void attribute(String metric, String value) {
        this.attribute(metric, value, NO_DIMENSIONS);
    }

    @Override
    public void attribute(String metric, String value, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("metric", metric);
            AbstractMetricsClient.requireNotEmpty("value", value);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        this.doAttribute(metric, value, dimensions);
    }

    @Override
    public void increment(String metric) {
        this.count(metric, 1L);
    }

    @Override
    public void increment(String metric, double sampleRate) {
        this.count(metric, 1L, sampleRate);
    }

    @Override
    public void increment(String metric, Set<Dimension> dimensions) {
        this.count(metric, 1L, dimensions);
    }

    @Override
    public void increment(String metric, double sampleRate, Set<Dimension> dimensions) {
        this.count(metric, 1L, sampleRate, dimensions);
    }

    @Override
    public void decrement(String metric) {
        this.count(metric, -1L);
    }

    @Override
    public void decrement(String metric, double sampleRate) {
        this.count(metric, -1L, sampleRate);
    }

    @Override
    public void decrement(String metric, Set<Dimension> dimensions) {
        this.count(metric, -1L, dimensions);
    }

    @Override
    public void decrement(String metric, double sampleRate, Set<Dimension> dimensions) {
        this.count(metric, -1L, sampleRate, dimensions);
    }

    @Override
    public void count(String metric, long delta) {
        this.count(metric, delta, 1.0, NO_DIMENSIONS);
    }

    @Override
    public void count(String metric, long delta, double sampleRate) {
        this.count(metric, delta, sampleRate, NO_DIMENSIONS);
    }

    @Override
    public void count(String metric, long delta, Set<Dimension> dimensions) {
        this.count(metric, delta, 1.0, dimensions);
    }

    @Override
    public void count(String metric, long delta, double sampleRate, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("metric", metric);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        if (AbstractMetricsClient.shouldSample(sampleRate)) {
            this.doCount(metric, delta, sampleRate, dimensions);
        }
    }

    @Override
    public void event(String name, String message, Severity severity) {
        this.event(name, message, severity, NO_DIMENSIONS);
    }

    @Override
    public void event(String name, String message, Severity severity, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("name", name);
            AbstractMetricsClient.requireNotEmpty("message", message);
            AbstractMetricsClient.requireNotNull("severity", (Object)severity);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        this.doEvent(name, message, severity, dimensions);
    }

    @Override
    public void gauge(String metric, double absoluteValue) {
        this.gauge(metric, absoluteValue, Unit.NONE);
    }

    @Override
    public void gauge(String metric, double absoluteValue, Unit unit) {
        this.gauge(metric, absoluteValue, unit, NO_DIMENSIONS);
    }

    @Override
    public void gauge(String metric, double absoluteValue, Set<Dimension> dimensions) {
        this.gauge(metric, absoluteValue, Unit.NONE, dimensions);
    }

    @Override
    public void gauge(String metric, double absoluteValue, Unit unit, Set<Dimension> dimensions) {
        this.gauge(metric, absoluteValue, false, unit, dimensions);
    }

    @Override
    public void adjustGauge(String metric, double delta) {
        this.gauge(metric, delta, true, Unit.NONE, NO_DIMENSIONS);
    }

    @Override
    public void adjustGauge(String metric, double delta, Unit unit) {
        this.gauge(metric, delta, true, unit, NO_DIMENSIONS);
    }

    @Override
    public void adjustGauge(String metric, double delta, Set<Dimension> dimensions) {
        this.gauge(metric, delta, true, Unit.NONE, dimensions);
    }

    @Override
    public void adjustGauge(String metric, double delta, Unit unit, Set<Dimension> dimensions) {
        this.gauge(metric, delta, true, unit, dimensions);
    }

    @Override
    public void gauge(String metric, DoubleSupplier supplier) {
        this.gauge(metric, supplier, Unit.NONE, NO_DIMENSIONS);
    }

    @Override
    public void gauge(String metric, DoubleSupplier supplier, Set<Dimension> dimensions) {
        this.gauge(metric, supplier, Unit.NONE, dimensions);
    }

    @Override
    public void gauge(String metric, DoubleSupplier supplier, Unit unit) {
        this.gauge(metric, supplier, unit, NO_DIMENSIONS);
    }

    @Override
    public void gauge(String metric, DoubleSupplier supplier, Unit unit, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("metric", metric);
            AbstractMetricsClient.requireNotNull("supplier", supplier);
            AbstractMetricsClient.requireNotNull("unit", (Object)unit);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
            GaugeSampler sampler = new GaugeSampler(metric, dimensions, unit, supplier);
            if (this.gaugeSamplers.putIfAbsent(metric, dimensions, sampler) != null) {
                throw new IllegalArgumentException(String.format("Gauge sampler with metric name '%s' and dimensions '%s' is already defined", metric, dimensions.stream().map(Dimension::toString).collect(Collectors.joining(","))));
            }
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        this.startSampling();
    }

    private void gauge(String metric, double value, boolean isDelta, Unit unit, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("metric", metric);
            AbstractMetricsClient.requireNotNull("unit", (Object)unit);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        this.doGauge(metric, value, isDelta, unit, dimensions);
    }

    private void startSampling() {
        if (this.sampling.compareAndSet(false, true)) {
            this.scheduleTask(() -> this.sample(this.gaugeSamplers), this.samplingInterval);
        }
    }

    private void sample(DimensionalMetricMap<? extends Sampler> map) {
        try {
            map.forEach((m, d, s) -> {
                if (this.closing.get()) {
                    return false;
                }
                s.sample();
                return true;
            });
        }
        catch (Throwable t) {
            this.errorCallback.accept(t);
        }
    }

    @Override
    public void removeGaugeSampler(String metric) {
        this.removeGaugeSampler(metric, NO_DIMENSIONS);
    }

    @Override
    public void removeGaugeSampler(String metric, Set<Dimension> dimensions) {
        this.gaugeSamplers.remove(metric, dimensions);
    }

    @Override
    public void clearGaugeSamplers() {
        this.gaugeSamplers.clear();
    }

    @Override
    public void timer(String metric, long millis) {
        this.timer(metric, millis, 1.0);
    }

    @Override
    public void timer(String metric, long millis, double sampleRate) {
        this.timer(metric, millis, TimeUnit.MILLISECONDS, sampleRate);
    }

    @Override
    public void timer(String metric, long millis, Set<Dimension> dimensions) {
        this.timer(metric, millis, 1.0, dimensions);
    }

    @Override
    public void timer(String metric, long millis, double sampleRate, Set<Dimension> dimensions) {
        this.timer(metric, millis, TimeUnit.MILLISECONDS, sampleRate, dimensions);
    }

    @Override
    public void timer(String metric, long value, TimeUnit unit) {
        this.timer(metric, value, unit, 1.0);
    }

    @Override
    public void timer(String metric, long value, TimeUnit unit, double sampleRate) {
        this.timer(metric, value, unit, sampleRate, NO_DIMENSIONS);
    }

    @Override
    public void timer(String metric, long value, TimeUnit unit, Set<Dimension> dimensions) {
        this.timer(metric, value, unit, 1.0, dimensions);
    }

    @Override
    public void timer(String metric, long value, TimeUnit unit, double sampleRate, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("metric", metric);
            AbstractMetricsClient.requireNotNull("unit", (Object)unit);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        if (AbstractMetricsClient.shouldSample(sampleRate)) {
            this.doTimer(metric, value, unit, sampleRate, dimensions);
        }
    }

    @Override
    public void unique(String metric, String identifier) {
        this.unique(metric, identifier, NO_DIMENSIONS);
    }

    @Override
    public void unique(String metric, String identifier, Set<Dimension> dimensions) {
        try {
            AbstractMetricsClient.requireNotEmpty("metric", metric);
            AbstractMetricsClient.requireNotNull("identifier", identifier);
            AbstractMetricsClient.requireNotNull("dimensions", dimensions);
        }
        catch (IllegalArgumentException ex) {
            this.errorCallback.accept(ex);
            return;
        }
        this.doUnique(metric, identifier, dimensions);
    }

    protected abstract void doAttribute(String var1, String var2, Set<Dimension> var3);

    protected abstract void doCount(String var1, long var2, double var4, Set<Dimension> var6);

    protected abstract void doEvent(String var1, String var2, Severity var3, Set<Dimension> var4);

    protected abstract void doGauge(String var1, double var2, boolean var4, Unit var5, Set<Dimension> var6);

    protected abstract void doTimer(String var1, long var2, TimeUnit var4, double var5, Set<Dimension> var7);

    protected abstract void doUnique(String var1, String var2, Set<Dimension> var3);

    protected static double fractionalMillis(long value, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return (double)value / 1000000.0;
            }
            case MICROSECONDS: {
                return (double)value / 1000.0;
            }
            case MILLISECONDS: 
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAYS: {
                return unit.toMillis(value);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() {
        if (this.closing.compareAndSet(false, true)) {
            this.doClose();
            try {
                this.executor.shutdownNow();
            }
            catch (SecurityException ex) {
                this.errorCallback.accept(ex);
            }
        }
    }

    protected void doClose() {
    }

    public final long getSamplingInterval() {
        return this.samplingInterval;
    }

    protected final boolean isClosing() {
        return this.closing.get();
    }

    protected void submitTask(Runnable task) {
        try {
            this.executor.submit(task);
        }
        catch (RejectedExecutionException ex) {
            this.errorCallback.accept(ex);
        }
    }

    protected void scheduleTask(Runnable task, long interval) {
        try {
            this.executor.scheduleAtFixedRate(task, interval, interval, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            this.errorCallback.accept(ex);
        }
    }

    protected static void requireNotEmpty(String param, String val) {
        if (InstrumentationUtils.isBlank(val)) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null or empty", param));
        }
    }

    protected static void requireNotNull(String param, Object val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null", param));
        }
    }

    protected static abstract class Sampler {
        protected final String metric;
        protected final Set<Dimension> dimensions;

        protected abstract void sample();

        protected Sampler(String metric, Set<Dimension> dimensions) {
            this.metric = metric;
            this.dimensions = dimensions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sampler)) {
                return false;
            }
            Sampler sampler = (Sampler)o;
            return Objects.equals(this.metric, sampler.metric) && Objects.equals(this.dimensions, sampler.dimensions);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + Objects.hashCode(this.metric);
            hash = 31 * hash + Objects.hashCode(this.dimensions);
            return hash;
        }
    }

    private final class GaugeSampler
    extends Sampler {
        private final Unit unit;
        private final DoubleSupplier supplier;

        GaugeSampler(String metric, Set<Dimension> dimensions, Unit unit, DoubleSupplier supplier) {
            super(metric, dimensions);
            this.unit = unit;
            this.supplier = supplier;
        }

        @Override
        protected void sample() {
            AbstractMetricsClient.this.gauge(this.metric, this.supplier.getAsDouble(), this.unit, (Set<Dimension>)this.dimensions);
        }
    }
}

